﻿* Encoding: UTF-8.
********************************************************************.

get file = 'gesamtstichprobe.sav'.
DATASET NAME stichprobe1.

dataset declare heimanteil1.
dataset activate stichprobe1.
sort cases by gemeindekennziffer.
aggregate outfile = heimanteil1
    /break = gemeindekennziffer
    /N_heim = sum(heim)
    /N_alle = N
    /anteil_heim2 = FGT(heim,0).
exec.
dataset activate heimanteil1.
sort cases by gemeindekennziffer.
alter type gemeindekennziffer (a24).

*** HEIMANTEIL NRW ZENSUS 2011.
GET DATA
  /TYPE=XLSX
  /FILE='Anteil_Heimbewohner_80undaelter.xlsx'
  /SHEET=name 'Tabelle1'
  /CELLRANGE=FULL
  /READNAMES=ON
  /DATATYPEMIN PERCENTAGE=95.0
  /HIDDEN IGNORE=YES.
EXECUTE.
DATASET NAME nrw1 WINDOW=FRONT.
dataset activate nrw1.
select if not sysmis(gemeindekennziffer).
exec.
alter type gemeindekennziffer (a24).
compute gemeindekennziffer = concat('0',LTRIM(gemeindekennziffer)).
exec.
sort cases by gemeindekennziffer.

dataset activate heimanteil1.
match files
    /file = *
    /table = nrw1
    /by gemeindekennziffer
    /drop = reggio_txt.
exec.

*** UMGANG MIT SPERRVERMERKEN IN DEN GEMEINDEN DER STICHPROBE.
GET DATA
  /TYPE=XLSX
  /FILE='NRW80plus_2017_Sperrvermerke.xlsx'
  /SHEET=name 'Liste'
  /CELLRANGE=FULL
  /READNAMES=ON
  /DATATYPEMIN PERCENTAGE=95.0
  /HIDDEN IGNORE=YES.
EXECUTE.
DATASET NAME sperr1 WINDOW=FRONT.
dataset activate sperr1.
sort cases by gemeindekennziffer.

dataset declare sperr_gemeinde1.
dataset activate sperr1.
aggregate outfile = sperr_gemeinde1
     /break = gemeindekennziffer
     /gemname1 = max(gemname1)
     /gemname2 = max(gemname2)
     /sperr_umgang = max(sperr_umgang)
     /points = sum(anzahl_points).
exec.

dataset activate sperr_gemeinde1.
alter type gemeindekennziffer (a24).
rename variables gemeindekennziffer = Gemeindekennziffer. 
exec.
   
dataset activate heimanteil1.
match files
    /file = *
    /table = sperr_gemeinde1
    /by Gemeindekennziffer.
exec.

dataset activate heimanteil1.
compute umgang = 0.
if any(sperr_umgang, 'ja, ohne Kennung', 'ja, mit Kennung', 'nein, nicht vorhanden') umgang = 1.
if any(sperr_umgang, 'keine Information') umgang = 2.
if any(sperr_umgang, 'nein, nicht mitgeliefert') umgang = 3.
variable labels umgang 'Kategorisierter Umgang mit Sperrkennzeichen'.
value labels umgang 
    1 'alles drin'
    2 'keine Information'
    3 'nicht drin'.
formats umgang (f1.0).
exec.

compute anteil_heim = anteil_heim2 * 100.
variable labels anteil_heim 'Anteil identifizierter Heime in Stichprobe'.
EXECUTE.

*** NUR DIE VERWENDEN, FÜR DIE IM ZENSUS DATEN VORLIEGEN.
dataset activate heimanteil1.
compute verwenden = 1.
if sysmis(zens11_h_perc) verwenden = 0.
exec.

*** NUR DIE, FÜR DIE EINE GKZ IN NRW VORLIEGT.
compute gültige_gkz = 0.
if (strunc(gemeindekennziffer,2) = '05') gültige_gkz = 1.
exec.

*** Alle Umgang-Ausprägungen.
dataset activate heimanteil1.
filter by verwenden.
sort cases by umgang.
dataset declare umgang_nurGültigeNRW1.
aggregate outfile = umgang_nurGültigeNRW1
     /break = umgang
    /n_stichprobe = n(gemeindekennziffer)
    /n_zensus = n(zens11_h_perc)
    /stich_alle = sum(N_alle)
    /stich_heim = sum(N_heim)
    /nrw_alle = sum(alle_nrw_absolut)
    /nrw_heim = sum(heim_nrw_absolut).
exec.
dataset activate umgang_nurGültigeNRW1.
compute anteil_heim_stich = stich_heim/stich_alle*100.
compute anteil_heim_nrw = nrw_heim/nrw_alle*100.
exec.    

*** Nur mit Daten im Zensus, alle Gemeinden.
dataset activate heimanteil1.
filter by verwenden.
dataset declare alle_nurGültigeNRW1.
aggregate outfile = alle_nurGültigeNRW1
     /break = verwenden
    /n_stichprobe = n(gemeindekennziffer)
    /n_zensus = n(zens11_h_perc)
    /stich_alle = sum(N_alle)
    /stich_heim = sum(N_heim)
    /nrw_alle = sum(alle_nrw_absolut)
    /nrw_heim = sum(heim_nrw_absolut).
exec.
dataset activate alle_nurGültigeNRW1.
compute anteil_heim_stich = stich_heim/stich_alle*100.
compute anteil_heim_nrw = nrw_heim/nrw_alle*100.
exec.

dataset close nrw1.
dataset close sperr1. 
dataset close sperr_gemeinde1.
dataset close stichprobe1.
dataset close heimanteil1.
